
MEMORY
{
PAGE 0 :  /* Program Memory */
          /* Memory (RAM/FLASH) blocks can be moved to PAGE1 for data allocation */
          /* BEGIN is used for the "boot to SARAM" bootloader mode   */

   BEGIN           	: origin = 0x080000, length = 0x000002
   RAMM0			: origin = 0x000200, length = 0x000200
   RAMLSD          	: origin = 0x008000, length = 0x004000
   RESET           	: origin = 0x3FFFC0, length = 0x000002

   /* Flash sectors */
   FLASHALL         : origin = 0x080002, length = 0x03FFFE	/* on-chip Flash */

PAGE 1 : /* Data Memory */
         /* Memory (RAM/FLASH) blocks can be moved to PAGE0 for program allocation */

   BOOT_RSVD		: origin = 0x000002, length = 0x000120     /* Part of M0, BOOT rom will use this for stack */
   RAMM1			: origin = 0x000122, length = 0x0006DE     /* on-chip RAM block M0/M1 */

   RAMGS			: origin = 0x00C000, length = 0x010000

   CPU2TOCPU1RAM   : origin = 0x03F800, length = 0x000400
   CPU1TOCPU2RAM   : origin = 0x03FC00, length = 0x000400
}


SECTIONS
{
   /* Allocate program areas: */
   codestart           : > BEGIN        PAGE = 0, ALIGN(4)
   wddisable		   : > FLASHALL,    PAGE = 0, ALIGN(4)
   copysections        : > FLASHALL,    PAGE = 0, ALIGN(4)

   .cinit              : > FLASHALL      PAGE = 0, ALIGN(4)
   .pinit              : > FLASHALL      PAGE = 0, ALIGN(4)
   .text               : > FLASHALL      PAGE = 0, ALIGN(4)

   ZeroSp1       :   LOAD = FLASHALL,
                         RUN = RAMLSD,
                         LOAD_START(_CinitLoadStart),
                         LOAD_SIZE(_CinitSize),
                         RUN_START(_CinitRunStart),
                         PAGE = 0
   ZeroSp2       :   LOAD = FLASHALL,
                         RUN = RAMLSD,
                         LOAD_START(_TextLoadStart),
                         LOAD_SIZE(_TextSize),
                         RUN_START(_TextRunStart),
                         PAGE = 0
   ZeroSp3       :   LOAD = FLASHALL,
                         RUN = RAMLSD,
                         LOAD_START(_PinitLoadStart),
                         LOAD_SIZE(_PinitSize),
                         RUN_START(_PinitRunStart),
                         PAGE = 0
   ZeroSp4       :   LOAD = FLASHALL,
                         RUN = RAMLSD,
                         LOAD_START(_SwitchLoadStart),
                         LOAD_SIZE(_SwitchSize),
                         RUN_START(_SwitchRunStart),
                         PAGE = 0
   ZeroSp5       :   LOAD = FLASHALL,
                         RUN = RAMLSD,
                         LOAD_START(_ConstLoadStart),
                         LOAD_SIZE(_ConstSize),
                         RUN_START(_ConstRunStart),
                         PAGE = 0
   ZeroSp6        :   LOAD = FLASHALL,
                         RUN = RAMLSD,
                         LOAD_START(_EconstLoadStart),
                         LOAD_SIZE(_EconstSize),
                         RUN_START(_EconstRunStart),
                         PAGE = 0


   /* Allocate uninitalized data sections: */
   .stack              : > RAMM1        PAGE = 1
   .ebss               : > RAMGS        PAGE = 1
   .esysmem            : > RAMGS        PAGE = 1
   .cio		           : > RAMGS        PAGE = 1

   /* Initalized sections go in Flash */
   .econst             : > FLASHALL     PAGE = 0, ALIGN(4)
   .switch             : > FLASHALL     PAGE = 0, ALIGN(4)

   .reset              : > RESET,       PAGE = 0, TYPE = DSECT /* not used, */

   ramfuncs            : LOAD = FLASHALL,
                         RUN = RAMM0,
                         LOAD_START(_RamfuncsLoadStart),
                         LOAD_SIZE(_RamfuncsSize),
                         RUN_START(_RamfuncsRunStart),
                         PAGE = 0, ALIGN(4)   
}

/*
//===========================================================================
// End of file.
//===========================================================================
*/
